### DCQO key datapoints
Oct-Dec 2023
6M quotes created
71K daily quotes created on avg
Out of which 1M quotes were ordered
### API outcome to business outcome links
- capture conversion rate for combination of client + endpoint used on quote/cart to order level. If there’s a change in the endpoint, capture before-after CR to understand increase in average revenue per order
	- for example - api /shipments is used by Premier Plus client today with certain conversion rate. Steps to arrive at $ value
		- for Premier Plus, get todays CR = number of orders placed / number of carts generated on DCQO APIs. 
		- Filter CR for when that API /shipments endpoint was used in the ordering process based on order details
		- When clients change the endpoint to /shipments/new endpoint, calculate CR again. 
		- Calculate delta in CR and understand improvement
### DCQO as a business
Cost of running DCQO = Human Resources + Infra costs (Storage, PCF) + License costs
Value to business = # of unique (carts + quotes) operated per week, # of orders submitted per week, $ revenue submitted to OM per week
Product Manager is responsible to ensure the product has value and is viable for the business
Engineering is responsible for feasibility
### Premier 
[Cart and Checkout Dashboard](https://app.powerbi.com/groups/me/apps/83b21c2a-d203-4267-9cb5-a08e4e5e9b63/reports/43ae3c53-edca-4f40-adfa-217208e3f5e4/ReportSection74e13ad6813c2bd1526b?ctid=945c199a-83a2-4e80-9f8c-5a91be5752dd&experience=power-bi&clientSideAuth=0)

### Adobe Analytics
Interesting dimensions
- Customer loyalty
- Visit depth
- Return frequency
- Day of the week
- 

### Opportunity tree
- increase revenue 
	- Increase AOV 
		- Show upsell options during purchase
			- Build recommendations engine
	- Increase conversion rate
		- Reduce operations/user actions in purchase
			- Authenticated user flow
				- Fetch shipping/billing info automatically 
			- Unauthenticated user flow
				- ?? 
		- Nudge customers during purchase
			- Social proof - Show purchase insights - XX users purchased this recently
			- FOMO - XX items left in stock
		- Reduce latency
			- Make APIs faster
			- Pre-calculate resources
		- Reduce drop off rates 
			- Cart email reminders
			- Reduce API errors in purchase flow
- Decrease cost
	- Increase story velocity, 
	- Reduce code duplication

### Types of features

-   Metrics movers - to purely improve performance of services
-   Customer requests - based on user requests
-   Delighters - unexpected features

### Metrics movers:

APIs have endpoints and talk to other services to perform a task.

Availability, Performance, Scalability

Availability -
-   Reduce friction, breaches, exceptions

Performance - Quicker response times
-   Smaller payloads
-   Faster services (increased network speed)
-   Better architectural design
    -   Event driven
    -   Caching
    -   Minimizing/Delaying validations
-   Geo-partitioning

### Customer requests:
-   Behavior and goal of end-user
-   Priorities of end-user - performance, security, design, functionality
-   Front-end applications define these many times
-   Key business metrics for DCQO:
    -   Revenue from orders, avg revenue per order
    -   Cart to order conversions, avg cart value
    -   Quote to cart and quote to order conversions, avg quote value
    -   Quotes created, avg quote value

### Delighter:
-   Cannot come from user, have to be understood indirectly
-   More difficult to understand, needs stronger understanding of end-user
### Potential options 
1.  API product usage by sourceApp/client and endpoints to understand how clients use our application
    1.  Latency - TP95 per client daily trend
    2.  Future: Anomaly detection per client
2.  API errors by client or SourceAppName
    1.  4xx errors - Client side errors. Insight based actions on DCQO:
        1.  Build better request validation logic
        2.  Improve documentation,
        3.  Education to clients on API usage
    2.  5xx errors - Server side errors. Insight based actions on DCQO:
        1.  Build better validation logic
        2.  Build better code to handle dependent team’s errors
3.  API product adoption/engagement by endpoints
    1.  Relationship between errors and transaction - which errors caused the transaction to fail vs which don’t
    2.  Quote, cart to order conversion by age, order value, version
        1.  Clustering potential. 85% of quotes don’t convert to orders
        2.  which factors predict quote conversion probability

-   1xx informational response – the request was received, continuing process
-   2xx successful – the request was successfully received, understood, and accepted
-   3xx redirection – further action needs to be taken in order to complete the request
-   4xx client error – the request contains bad syntax or cannot be fulfilled
-   5xx server error – the server failed to fulfil an apparently valid request

Shreeja’s monthly deck

Cart, quote, order products performance

Splunk is for application performance

Calls made by clients, IP, response time
Error distribution, trends
Traffic distribution
Data warehouse system will need to track following -
Revenue distribution
Friction points / dropoffs
Splunk - machine data logging engine, depends on what data we log
-   Server health
-   Container health
-   Custom logging of errors, exceptions of API
IAS is a host service by Microsoft: Internet Authentication Service

Quote, Cart - primary interfaces for any sales channel -

-   Check with them on revenue loss within splunk
-   Cart - Rajesh Kejivitol

2 types of PCF logs -
-   Metrics dataset
-   Diego cell dataset